# PPSP Dual-Platform Secure Wipe Suite

Complete data destruction solution for macOS and Windows with USB serial generator.

## 📦 Package Contents

```
ppsp-dual-platform/
├── mac-app/                    # macOS Application
│   ├── package.json           # Dependencies & build config
│   ├── main.js                # Main process with real diskutil
│   └── index.html             # User interface
│
├── windows-app/               # Windows Application
│   ├── package.json           # Dependencies & build config
│   ├── main.js                # Main process with cipher/format
│   └── index.html             # User interface
│
└── usb-serial-generator/      # License Key Tool
    └── index.html             # Web-based generator
```

## 🍎 macOS App

### Features
- Real drive wiping using `diskutil secureErase`
- 4 security levels (0-3) matching DoD/NIST/Gutmann
- System drive protection (cannot wipe /)
- Administrator password required
- Certificate generation

### Build Instructions

```bash
cd mac-app

# Install dependencies
npm install

# Build for Mac
npm run build:mac

# Or universal (Intel + Apple Silicon)
npm run build:mac:universal
```

**Output:** `dist/PPSP Secure Wipe.dmg`

### Security Levels

| Level | Passes | Method | Use Case |
|-------|--------|--------|----------|
| 0 | 1 | Zeros | Quick erase |
| 1 | 1 | Random | NIST 800-88 |
| 2 | 7 | DoD 5220.22-M | High security |
| 3 | 35 | Gutmann | Maximum security |
| 4 | 3 | DoD Short | Standard DoD |

## 🖥️ Windows App

### Features
- Drive wiping using Windows `cipher` or `format` commands
- Administrator privileges required
- C: drive protection
- Portable version available
- Certificate generation

### Build Instructions

On Windows PC:
```cmd
cd windows-app

# Install dependencies
npm install

# Build installer
npm run build:win

# Build portable exe
npm run build:win:portable
```

**Outputs:**
- `dist/PPSP Secure Wipe Setup.exe` (Installer)
- `dist/PPSP Secure Wipe.exe` (Portable)

## 🔐 USB Serial Generator

Web-based tool to generate hardware-bound license keys.

### Features
- Generate unique serial numbers
- Hardware hash binding
- Batch generation (up to 100 keys)
- Verification tool
- Export to CSV/TXT

### Usage

1. Open `usb-serial-generator/index.html` in any browser
2. Enter USB device info (Vendor, Model, Serial)
3. Select license tier and expiry
4. Click "Generate"
5. Use generated key with Linux build script

### Serial Number Format

```
XXXX-XXXX-XXXX-XXXX
│   │   │   │
│   │   │   └── Sequential number
│   │   └── Tier code + random
│   └── Hardware hash (first 4 chars)
└── Random
```

Example: `A3F9-B2C4-PR8D-0001`

## 🔒 Anti-Copy Protection (USB)

To create hardware-bound USB:

1. **Get USB Info:**
   ```bash
   # Linux
   lsusb -v | grep -E "(idVendor|idProduct|iSerial)"

   # macOS
   system_profiler SPUSBDataType
   ```

2. **Generate License:**
   Use the web generator or:
   ```bash
   # Format: VENDOR-MODEL-SERIAL-HASH
   echo -n "SanDiskCruzer4C5300012304" | sha256sum | cut -c1-8
   # Result: Hardware hash
   ```

3. **Build USB:**
   ```bash
   sudo ./build-secure-usb.sh /dev/sdX XXXX-XXXX-XXXX-XXXX
   ```

## ⚠️ Safety Warnings

### Before Using Real Wipe:

1. **TEST FIRST** - Use spare USB drive
2. **VERIFY** - Double-check selected drive
3. **BACKUP** - All data will be destroyed
4. **POWER** - Ensure stable power during wipe
5. **DOCUMENT** - Get customer authorization

### System Protection

- **Mac:** Blocks `/` (root) filesystem
- **Windows:** Blocks `C:` drive
- Both require Administrator privileges

## 📋 Quick Start

### For Mac:
```bash
cd mac-app
npm install
npm run build:mac
open dist/
```

### For Windows:
```cmd
cd windows-app
npm install
npm run build:win
dist\PPSP Secure Wipe Setup.exe
```

### For USB Serial:
```bash
# Open in browser
open usb-serial-generator/index.html

# Or serve locally
cd usb-serial-generator
python3 -m http.server 8000
# Visit http://localhost:8000
```

## 🆘 Support

**PPSP Recycling LLC**  
9095 Elk Grove Blvd Suite B  
Elk Grove, CA 95624  
Phone: 916-381-8304

## 📄 License

Internal use only - PPSP Recycling LLC
